﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Configuration;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data;

using DataAccess;

/// <summary>
/// CRegionSite class is used to retrieve region and site data
/// </summary>
public class CRegionSite
{
	protected BaseMaster m_BaseMstr;

    /// <summary>
    /// US:5348 constructor takes basemaster 
    /// </summary>
    /// <param name="BaseMstr"></param>
    public CRegionSite(BaseMaster BaseMstr)
	{
        m_BaseMstr = BaseMstr;
    }

    /// <summary>
    /// US:5348 Gets a dataset of all regions, will transfer regions form MDWS etc as needed
    /// </summary>
    /// <returns></returns>
    public DataSet GetRegionsDS()
    {
        //NOTE: we will no longer transfer regions from MDWS. this piece is going away 
        //for security reasons in VIA. the region table will be pre-loaded with all regions
        //needed
        //if we are connected to MDWS, transfer regions and sites from MDWS to the central db
        //this call will transfer both regions and all sites for each region
        //if (m_BaseMstr.MDWSTransfer)
        //{
        //    CMDWSOps ops = new CMDWSOps(m_BaseMstr.GetDataObject());
        //    CStatus status = ops.TransferSites();
        //    if (!status.Status)
        //    {
        //        //show the error, dont return as we can still retrieve what we have
        //        m_BaseMstr.StatusCode =(long) status.StatusCode;
         //       m_BaseMstr.StatusComment = status.StatusComment;
           // }
        //}

        //ds to return
        DataSet ds = null;

        //status info
        long lStatusCode = 0;
        string strStatusComment = "";

        //now get a dataset of regions from the central db
        //create a new parameter list with standard params from basemstr
        CDataParameterList pList = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);
        CDataSet cds = new CDataSet();
        ds = cds.GetOracleDataSet( m_BaseMstr.DBConn,
                                   "PCK_REGION_SITE.GetRegionRS",
                                   pList,
                                   out lStatusCode,
                                   out strStatusComment);

        //set the base master status code and status for display if call failed
        if (lStatusCode != 0)
        {
            m_BaseMstr.StatusCode = lStatusCode;
            m_BaseMstr.StatusComment = strStatusComment;
        }

        return ds;
    }

    /// <summary>
    /// US:5348 gets a dataset of all sites for one region
    /// </summary>
    /// <param name="lRegionID"></param>
    /// <returns></returns>
    public DataSet GetSiteDS(long lRegionID)
    {
        //NOTE: we will no longer transfer sites from MDWS. this piece is going away 
        //for security reasons in VIA. the site table will be pre-loaded with all regions
        //needed
        //if (m_BaseMstr.MDWSTransfer)
        //{
        //    //note: do not need to transfer sites, they are transferred in the region call
        //}

        //ds to return
        DataSet ds = null;

        //status info
        long lStatusCode = 0;
        string strStatusComment = "";

        //now get a dataset of regions from the central db
        //create a new parameter list with standard params from basemstr
        CDataParameterList pList = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        //add in the region id param
        pList.AddInputParameter("pi_nRegionID", lRegionID);

        CDataSet cds = new CDataSet();
        ds = cds.GetOracleDataSet(m_BaseMstr.DBConn,
                                   "PCK_REGION_SITE.GetSiteRS",
                                   pList,
                                   out lStatusCode,
                                   out strStatusComment);

        //set the base master status code and status for display if call failed
        if (lStatusCode != 0)
        {
            m_BaseMstr.StatusCode = lStatusCode;
            m_BaseMstr.StatusComment = strStatusComment;
        }

        return ds;
    }

    /// <summary>
    /// gets the site and region matching the server and port passed in
    /// used when accessing the site from the CPRS tools menu
    /// </summary>
    /// <param name="strSRV"></param>
    /// <param name="strPort"></param>
    /// <returns></returns>
    public DataSet GetSiteDS(string strSRV,
                             string strPort)
    {
        //ds to return
        DataSet ds = null;

        //status info
        long lStatusCode = 0;
        string strStatusComment = "";

        //now get a dataset of regions from the central db
        //create a new parameter list with standard params from basemstr
        CDataParameterList pList = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        //add in the region id param
        pList.AddInputParameter("pi_vSRV", strSRV);
        pList.AddInputParameter("pi_vPORT", strPort);

        CDataSet cds = new CDataSet();
        ds = cds.GetOracleDataSet(m_BaseMstr.DBConn,
                                   "PCK_REGION_SITE.GetSiteRS",
                                   pList,
                                   out lStatusCode,
                                   out strStatusComment);

        //set the base master status code and status for display if call failed
        if (lStatusCode != 0)
        {
            m_BaseMstr.StatusCode = lStatusCode;
            m_BaseMstr.StatusComment = strStatusComment;
        }

        return ds;
    }


    public DataSet GetSiteDS()
    {
        //ds to return
        DataSet ds = null;

        //status info
        long lStatusCode = 0;
        string strStatusComment = "";

        //now get a dataset of regions from the central db
        //create a new parameter list with standard params from basemstr
        CDataParameterList pList = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        CDataSet cds = new CDataSet();
        ds = cds.GetOracleDataSet(m_BaseMstr.DBConn,
                                   "PCK_REGION_SITE.GetSiteRS",
                                   pList,
                                   out lStatusCode,
                                   out strStatusComment);

        //set the base master status code and status for display if call failed
        if (lStatusCode != 0)
        {
            m_BaseMstr.StatusCode = lStatusCode;
            m_BaseMstr.StatusComment = strStatusComment;
        }

        return ds;
    }

}